<?php

/**
 * This file is part of the Tracy (https://tracy.nette.org)
 * Copyright (c) 2004 David Grudl (https://davidgrudl.com)
 */

namespace Tracy\Dumper;

/**
 * @internal
 */
final class Value implements \JsonSerializable
{
    const TYPE_ARRAY = 'array';

    const TYPE_BINARY_HTML = 'bin';

    const TYPE_NUMBER = 'number';

    const TYPE_OBJECT = 'object';

    const TYPE_REF = 'ref';

    const TYPE_RESOURCE = 'resource';

    const TYPE_STRING_HTML = 'string';

    const TYPE_TEXT = 'text';

    const PROP_PUBLIC = 0;

    const PROP_PROTECTED = 1;

    const PROP_PRIVATE = 2;

    const PROP_DYNAMIC = 3;

    const PROP_VIRTUAL = 4;

    /** @var string */
    public $type;

    /** @var string|int */
    public $value;

    /** @var ?int */
    public $length;

    /** @var ?int */
    public $depth;

    /** @var int|string */
    public $id;

    /** @var object */
    public $holder;

    /** @var ?array */
    public $items;

    /** @var ?\stdClass */
    public $editor;

    /** @var ?bool */
    public $collapsed;

    public function __construct($type, $value = null, $length = null)
    {
        $this->type = $type;
        $this->value = $value;
        $this->length = $length;
    }

    public function jsonSerialize(): array
    {
        $res = array($this->type => $this->value);
        foreach (array('length', 'editor', 'items', 'collapsed') as $k)
        {
            if ($this->{$k} !== null)
            {
                $res[$k] = $this->{$k};
            }
        }

        return $res;
    }
}
